/* Copyright (C) 2012-2018 RealVNC Ltd. All Rights Reserved.
 *
 * This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#include "UsbDevice.h"
#include <stdlib.h>

using namespace vncdeviceprovider_usb;

UsbDevice::UsbDevice(vnc_uint8_t busNum, vnc_uint8_t devNum,
    const char* pSysPath, const char* pSerial)
  : mBusNum(busNum),
    mDevNum(devNum),
    mpSerial(NULL)
{
  assert(pSysPath);
  assert(strlen(pSysPath) < MAX_SYS_PATH_SIZE);
  if(pSysPath)
  {
    strncpy(mSysPath, pSysPath, MAX_SYS_PATH_SIZE);
    mSysPath[MAX_SYS_PATH_SIZE] = '\0';
  }
  else
  {
    mSysPath[0] = '\0';
  }
  if(pSerial)
  {
    mpSerial = (char*) malloc(strlen(pSerial)+1);
    if(mpSerial)
    {
      strcpy(mpSerial, pSerial);
    }
  }
}

UsbDevice::UsbDevice(const UsbDevice& other)
  : mBusNum(other.mBusNum),
    mDevNum(other.mDevNum),
    mpSerial(NULL)
{
  strcpy(mSysPath, other.mSysPath);
  if(other.mpSerial)
  {
    mpSerial = (char*) malloc(strlen(other.mpSerial)+1);
    if(mpSerial)
    {
      strcpy(mpSerial, other.mpSerial);
    }
  }
}

UsbDevice::~UsbDevice()
{
  if(mpSerial)
  {
    free(mpSerial);
  }
}

const char* UsbDevice::sysPath() const
{
  return mSysPath;
}

vnc_uint8_t UsbDevice::busNum() const
{
  return mBusNum;
}

vnc_uint8_t UsbDevice::devNum() const
{
  return mDevNum;
}

const char* UsbDevice::serial() const
{
  return mpSerial;
}

vnc_uint32_t UsbDevice::composeId() const
{
  return composeId(mBusNum, mDevNum);
}

vnc_uint32_t UsbDevice::InvalidId()
{
  return 0xFFFFFFFF;
}

vnc_uint32_t UsbDevice::composeId(vnc_uint8_t busNum, vnc_uint8_t devNum)
{
  return ((busNum << 8) | devNum);
}

void UsbDevice::getBusAndDevNums(vnc_uint32_t id,
                                 vnc_uint8_t& bus, vnc_uint8_t& dev)
{
  bus = (vnc_uint8_t)((id >> 8) & 0xFF);
  dev = (vnc_uint8_t)(id & 0xFF);
}
